% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infomattest.R
\name{thselect.sdinfo}
\alias{thselect.sdinfo}
\title{Threshold selection diagnostic of Suveges and Davison}
\usage{
thselect.sdinfo(xdat, thresh, qlev, plot = FALSE, kmax = 1)
}
\arguments{
\item{xdat}{[vector] vector of observations}

\item{thresh}{[vector] candidate thresholds}

\item{qlev}{[vector] probability levels to define threshold if \code{thresh} is missing.}

\item{plot}{[logical]; should the graphical diagnostic be plotted?}

\item{kmax}{[int] the largest K-gap under consideration for clusters}
}
\value{
an invisible list of class  with elements
\itemize{
\item \code{thresh} a vector of thresholds based on empirical quantiles at supplied levels.
\item \code{stat} a matrix of test statistics
\item \code{pval} a matrix of approximate p-values (corresponding to probabilities under a \eqn{\chi^2_1}{chi-square(1)} distribution)
\item \code{mle} a matrix of maximum likelihood estimates for each given pair of thresholds and gaps
\item \code{loglik} a matrix of log-likelihood values at MLE for each given pair of elements in \code{thresh} and gap in \eqn{0, \ldots,\code{kmax}}
\item \code{quantile} quantile levels for thresholds, if supplied by the user
\item \code{kmax} the largest gap number
}
}
\description{
The information matrix test (IMT), proposed by Suveges and Davison (2010), is based
on the difference between the expected quadratic score and the second derivative of
the log-likelihood. The asymptotic distribution for each threshold \code{u} and gap \code{K}
is asymptotically \eqn{\chi^2}{chi-square} with one degree of freedom. The approximation is good for
\eqn{N>80} and conservative for smaller sample sizes. The test assumes independence between gaps.
}
\details{
The procedure proposed in Suveges & Davison (2010) was corrected for erratas.
The maximum likelihood is based on the limiting mixture distribution of
the intervals between exceedances (an exponential with a point mass at zero).
The condition \eqn{D^{(K)}(u_n)}{D^K(u)} should be checked by the user.

Fukutome et al. (2015) propose an ad hoc automated procedure
\enumerate{
\item Calculate the interexceedance times for each K-gap and each threshold, along with the number of clusters
\item  Select the (\code{u}, \code{K}) pairs for which IMT < 0.05 (corresponding to a P-value of 0.82)
\item Among those, select the pair (\code{u}, \code{K}) for which the number of clusters is the largest
}
}
\examples{
thselect.sdinfo(
  xdat = rgp(n = 10000),
  qlev = seq(0.1, 0.9, length = 10),
  kmax = 3)
}
\references{
Fukutome, Liniger and Suveges (2015), Automatic threshold and run parameter selection: a climatology for extreme hourly precipitation in Switzerland. \emph{Theoretical and Applied Climatology}, \strong{120}(3), 403-416.

Suveges and Davison (2010), Model misspecification in peaks over threshold analysis. \emph{Annals of Applied Statistics}, \strong{4}(1), 203-221.

White (1982), Maximum Likelihood Estimation of Misspecified Models. \emph{Econometrica}, \strong{50}(1), 1-25.
}
\author{
Leo Belzile
}
