% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{set_design_info}
\alias{set_design_info}
\title{Set ALT Design Information}
\usage{
set_design_info(
  k_levels,
  j_factor,
  n_unit,
  censor_time,
  p,
  use_cond,
  sigma,
  x_l = 0,
  x_h = 1,
  opt_type = "C",
  reparam = TRUE
)
}
\arguments{
\item{k_levels}{Integer. Number of stress levels.}

\item{j_factor}{Integer. Number of stress factors.}

\item{n_unit}{Integer. Total number of test units.}

\item{censor_time}{Numeric. Test duration or censoring time.}

\item{p}{Numeric. 0 < p < 1. Lifetime percentile to be estimated at the use condition, i.e. stress levels are 0.}

\item{use_cond}{Vector. Stress levels at the use condition.}

\item{sigma}{Numeric. Scale parameter of the lifetime distribution.}

\item{x_l}{Numeric. Lower bound of stress range. Default is 0.}

\item{x_h}{Numeric. Upper bound of stress range. Default is 1.}

\item{opt_type}{Character. Optimality criterion, currently only C-optimality is supported. Default is "C".}

\item{reparam}{Logical. Whether reparameterization is applied to model parameters. Reparameterization is supported for all design types, while non-reparameterization is only available for locally optimal design \code{design_type = 1}. Default is TRUE.}
}
\value{
A list of design specifications
}
\description{
Configures the settings for an accelerated life test.
}
\examples{
design_info <- set_design_info(k_levels=3, j_factor=1, n_unit=300, 
                           censor_time=183, p=0.1, use_cond=c(0), sigma=0.6)
}
