% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_digits.R
\name{format_digits}
\alias{format_digits}
\title{Format Numeric Columns with Specified Digits}
\usage{
format_digits(data, cols = NULL, digits = 2, percentage = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} or \code{data.table}. The input data containing numeric columns to format.}

\item{cols}{An optional numeric or character vector specifying the columns to format. If \code{NULL} (default), all numeric columns are formatted.}

\item{digits}{A non-negative integer specifying the number of decimal places to use. Defaults to \code{2}.}

\item{percentage}{A logical value indicating whether to format the numbers as percentages. If \code{TRUE}, the numbers are multiplied by 100 and a percent sign (\verb{\%}) is appended. Defaults to \code{FALSE}.}
}
\value{
A \code{data.table} with the specified numeric columns formatted as character strings with the specified number of decimal places. If \code{percentage = TRUE}, the numbers are shown as percentages.
}
\description{
The \code{format_digits} function formats numeric columns in a data frame or data table by rounding numbers to a specified number of decimal places and converting them to character strings. It can optionally format the numbers as percentages.
}
\details{
The function performs the following steps:
\enumerate{
\item Validates the input parameters, ensuring that \code{data} is a \code{data.frame} or \code{data.table}, \code{cols} (if provided) are valid column names or indices, and \code{digits} is a non-negative integer.
\item Converts \code{data} to a \code{data.table} if it is not already one.
\item Creates a formatting function based on the \code{digits} and \code{percentage} parameters:
\itemize{
\item If \code{percentage = FALSE}, numbers are rounded to \code{digits} decimal places.
\item If \code{percentage = TRUE}, numbers are multiplied by 100, rounded to \code{digits} decimal places, and a percent sign (\verb{\%}) is appended.
}
\item Applies the formatting function to the specified columns:
\itemize{
\item If \code{cols} is \code{NULL}, the function formats all numeric columns in \code{data}.
\item If \code{cols} is specified, only those columns are formatted.
}
\item Returns a new \code{data.table} with the formatted columns.
}
}
\note{
\itemize{
\item The input \code{data} must be a \code{data.frame} or \code{data.table}.
\item If \code{cols} is specified, it must be a vector of valid column names or indices present in \code{data}.
\item The \code{digits} parameter must be a single non-negative integer.
\item The original \code{data} is not modified; a modified copy is returned.
}
}
\examples{
# Example: Number formatting demonstrations

# Setup test data
dt <- data.table::data.table(
  a = c(0.1234, 0.5678),      # Numeric column 1
  b = c(0.2345, 0.6789),      # Numeric column 2
  c = c("text1", "text2")     # Text column
)

# Example 1: Format all numeric columns
format_digits(
  dt,                         # Input data table
  digits = 2                  # Round to 2 decimal places
)

# Example 2: Format specific column as percentage
format_digits(
  dt,                         # Input data table
  cols = c("a"),              # Only format column 'a'
  digits = 2,                 # Round to 2 decimal places
  percentage = TRUE           # Convert to percentage
)
}
