% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{gseq.rev}
\alias{gseq.rev}
\title{Reverse DNA sequence}
\usage{
gseq.rev(seq)
}
\arguments{
\item{seq}{A character vector containing DNA sequences. Preserves case and handles NA values.}
}
\value{
A character vector of the same length as the input, containing the reversed sequences
}
\description{
Takes a DNA sequence string and returns its reverse (without complementing).
}
\examples{
gseq.rev("ACTG") # Returns "GTCA"
gseq.rev(c("ACTG", "GGCC")) # Returns c("GTCA", "CCGG")
gseq.rev(c("ACTG", NA, "GGCC")) # Returns c("GTCA", NA, "CCGG")

}
\seealso{
\code{\link{gseq.revcomp}}, \code{\link{gseq.comp}}
}
