% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-create.R
\name{gtrack.create_sparse}
\alias{gtrack.create_sparse}
\title{Creates a 'Sparse' track from intervals and values}
\usage{
gtrack.create_sparse(
  track = NULL,
  description = NULL,
  intervals = NULL,
  values = NULL
)
}
\arguments{
\item{track}{track name}

\item{description}{a character string description}

\item{intervals}{a set of one-dimensional intervals}

\item{values}{an array of numeric values - one for each interval}
}
\value{
None.
}
\description{
Creates a 'Sparse' track from intervals and values.
}
\details{
This function creates a new 'Sparse' track with values at given intervals.
'description' is added as a track attribute.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- gintervals.load("annotations")
gtrack.create_sparse(
    "test_sparse", "Test track", intervs,
    1:dim(intervs)[1]
)
gextract("test_sparse", .misha$ALLGENOME)
gtrack.rm("test_sparse", force = TRUE)

}
\seealso{
\code{\link{gtrack.create}}, \code{\link{gtrack.2d.create}},
\code{\link{gtrack.smooth}}, \code{\link{gtrack.modify}},
\code{\link{gtrack.rm}}, \code{\link{gtrack.info}},
\code{\link{gdir.create}}
}
\keyword{~create}
\keyword{~sparse}
\keyword{~track}
