% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.mplus.R
\name{write.mplus}
\alias{write.mplus}
\title{Write Mplus Data File}
\usage{
write.mplus(x, file = "Mplus_Data.dat", data = TRUE, input = TRUE,
            var = FALSE, na = -99, check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame to be written to a tab-delimited file.}

\item{file}{a character string naming a file with or without the file extension
'.dat', e.g., \code{"Mplus_Data.dat"} or \code{"Mplus_Data"}.}

\item{data}{logical: if \code{TRUE} (default), Mplus data file is written in a
text file named according to the argument\code{file}.}

\item{input}{logical: if \code{TRUE} (default), Mplus input template is written
in a text file named according to the argument\code{file} with the
extension \code{_INPUT.inp}.}

\item{var}{logical: if \code{TRUE}, variable names are written in a text file
named according to the argument\code{file} with the extension
\code{_VARNAMES.txt}.}

\item{na}{a numeric value or character string representing missing values
(\code{NA}) in the data set.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}
}
\value{
Returns a character string indicating the variable names for the Mplus input file.
}
\description{
This function writes a matrix or data frame to a tab-delimited file without variable
names, a Mplus input template, and a text file with variable names. Note that only
numeric variables are allowed, i.e., non-numeric variables will be removed from
the data set. Missing data will be coded as a single numeric value.
}
\examples{
\dontrun{

# Example 1: Write Mplus Data File and a Mplus input template
write.mplus(mtcars)

# Example 2: Write Mplus Data File "mtcars.dat" and a Mplus input template "mtcars_INPUT.inp",
# missing values coded with -999,
# write variable names in a text file called "mtcars_VARNAMES.inp"
write.mplus(mtcars, file = "mtcars.dat", var = TRUE, na = -999)
}
}
\references{
Muthen, L. K., & Muthen, B. O. (1998-2017). \emph{Mplus User's Guide} (8th ed.).
Muthen & Muthen.
}
\seealso{
\code{\link{read.mplus}}, \code{\link{mplus.run}}, \code{\link{write.sav}},
\code{\link{write.xlsx}}, \code{\link{write.dta}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
