% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastmks.R
\name{fastmks}
\alias{fastmks}
\title{FastMKS (Fast Max-Kernel Search)}
\usage{
fastmks(
  bandwidth = NA,
  base = NA,
  degree = NA,
  input_model = NA,
  k = NA,
  kernel = NA,
  naive = FALSE,
  offset = NA,
  query = NA,
  reference = NA,
  scale = NA,
  single = FALSE,
  verbose = getOption("mlpack.verbose", FALSE)
)
}
\arguments{
\item{bandwidth}{Bandwidth (for Gaussian, Epanechnikov, and triangular
kernels).  Default value "1" (numeric).}

\item{base}{Base to use during cover tree construction.  Default value
"2" (numeric).}

\item{degree}{Degree of polynomial kernel.  Default value "2"
(numeric).}

\item{input_model}{Input FastMKS model to use (FastMKSModel).}

\item{k}{Number of maximum kernels to find.  Default value "0"
(integer).}

\item{kernel}{Kernel type to use: 'linear', 'polynomial', 'cosine',
'gaussian', 'epanechnikov', 'triangular', 'hyptan'.  Default value "linear"
(character).}

\item{naive}{If true, O(n^2) naive mode is used for computation. 
Default value "FALSE" (logical).}

\item{offset}{Offset of kernel (for polynomial and hyptan kernels). 
Default value "0" (numeric).}

\item{query}{The query dataset (numeric matrix).}

\item{reference}{The reference dataset (numeric matrix).}

\item{scale}{Scale of kernel (for hyptan kernel).  Default value "1"
(numeric).}

\item{single}{If true, single-tree search is used (as opposed to
dual-tree search.  Default value "FALSE" (logical).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value
"getOption("mlpack.verbose", FALSE)" (logical).}
}
\value{
A list with several components:
\item{indices}{Output matrix of indices (integer matrix).}
\item{kernels}{Output matrix of kernels (numeric matrix).}
\item{output_model}{Output for FastMKS model (FastMKSModel).}
}
\description{
An implementation of the single-tree and dual-tree fast max-kernel search
(FastMKS) algorithm.  Given a set of reference points and a set of query
points, this can find the reference point with maximum kernel value for each
query point; trained models can be reused for future queries.
}
\details{
This program will find the k maximum kernels of a set of points, using a
query set and a reference set (which can optionally be the same set). More
specifically, for each point in the query set, the k points in the reference
set with maximum kernel evaluations are found.  The kernel function used is
specified with the "kernel" parameter.
}
\examples{
# For example, the following command will calculate, for each point in the
# query set "query", the five points in the reference set "reference" with
# maximum kernel evaluation using the linear kernel.  The kernel evaluations
# may be saved with the  "kernels" output parameter and the indices may be
# saved with the "indices" output parameter.

\dontrun{
output <- fastmks(k=5, reference=reference, query=query, kernel="linear")
indices <- output$indices
kernels <- output$kernels
}

# The output matrices are organized such that row i and column j in the
# indices matrix corresponds to the index of the point in the reference set
# that has j'th largest kernel evaluation with the point in the query set
# with index i.  Row i and column j in the kernels matrix corresponds to the
# kernel evaluation between those two points.
# 
# This program performs FastMKS using a cover tree.  The base used to build
# the cover tree can be specified with the "base" parameter.
}
\author{
mlpack developers
}
