% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArchiveAsyncTuningFrozen.R
\name{ArchiveAsyncTuningFrozen}
\alias{ArchiveAsyncTuningFrozen}
\title{Frozen Rush Data Storage}
\description{
Freezes the Redis data base of an \link{ArchiveAsyncTuning} to a  \code{data.table::data.table()}.
No further points can be added to the archive but the data can be accessed and analyzed.
Useful when the Redis data base is not permanently available.
Use the callback \link{mlr3tuning.async_freeze_archive} to freeze the archive after the optimization has finished.
}
\section{S3 Methods}{

\itemize{
\item \code{as.data.table(archive)}\cr
\link{ArchiveAsyncTuningFrozen} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a tabular view of all performed function calls of the Objective.
The \code{x_domain} column is unnested to separate columns.
}
}

\section{Super classes}{
\code{\link[bbotk:Archive]{bbotk::Archive}} -> \code{\link[bbotk:ArchiveAsync]{bbotk::ArchiveAsync}} -> \code{\link[bbotk:ArchiveAsyncFrozen]{bbotk::ArchiveAsyncFrozen}} -> \code{ArchiveAsyncTuningFrozen}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{internal_search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
The search space containing those parameters that are internally optimized by the \code{\link[mlr3:Learner]{mlr3::Learner}}.}

\item{\code{benchmark_result}}{(\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult})\cr
Benchmark result.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ArchiveAsyncTuningFrozen-new}{\code{ArchiveAsyncTuningFrozen$new()}}
\item \href{#method-ArchiveAsyncTuningFrozen-learner}{\code{ArchiveAsyncTuningFrozen$learner()}}
\item \href{#method-ArchiveAsyncTuningFrozen-learners}{\code{ArchiveAsyncTuningFrozen$learners()}}
\item \href{#method-ArchiveAsyncTuningFrozen-learner_param_vals}{\code{ArchiveAsyncTuningFrozen$learner_param_vals()}}
\item \href{#method-ArchiveAsyncTuningFrozen-predictions}{\code{ArchiveAsyncTuningFrozen$predictions()}}
\item \href{#method-ArchiveAsyncTuningFrozen-resample_result}{\code{ArchiveAsyncTuningFrozen$resample_result()}}
\item \href{#method-ArchiveAsyncTuningFrozen-print}{\code{ArchiveAsyncTuningFrozen$print()}}
\item \href{#method-ArchiveAsyncTuningFrozen-clone}{\code{ArchiveAsyncTuningFrozen$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="format"><a href='../../bbotk/html/Archive.html#method-Archive-format'><code>bbotk::Archive$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="help"><a href='../../bbotk/html/Archive.html#method-Archive-help'><code>bbotk::Archive$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="best"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-best'><code>bbotk::ArchiveAsync$best()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsync" data-id="nds_selection"><a href='../../bbotk/html/ArchiveAsync.html#method-ArchiveAsync-nds_selection'><code>bbotk::ArchiveAsync$nds_selection()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="clear"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-clear'><code>bbotk::ArchiveAsyncFrozen$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="data_with_state"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-data_with_state'><code>bbotk::ArchiveAsyncFrozen$data_with_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="pop_point"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-pop_point'><code>bbotk::ArchiveAsyncFrozen$pop_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="push_failed_point"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-push_failed_point'><code>bbotk::ArchiveAsyncFrozen$push_failed_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="push_points"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-push_points'><code>bbotk::ArchiveAsyncFrozen$push_points()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="push_result"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-push_result'><code>bbotk::ArchiveAsyncFrozen$push_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="ArchiveAsyncFrozen" data-id="push_running_point"><a href='../../bbotk/html/ArchiveAsyncFrozen.html#method-ArchiveAsyncFrozen-push_running_point'><code>bbotk::ArchiveAsyncFrozen$push_running_point()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuningFrozen-new"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuningFrozen-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuningFrozen$new(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{(\link{ArchiveAsyncTuning})\cr
The archive to freeze.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuningFrozen-learner"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuningFrozen-learner}{}}}
\subsection{Method \code{learner()}}{
Retrieve \link[mlr3:Learner]{mlr3::Learner} of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
Learner does not contain a model. Use \verb{$learners()} to get learners with models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuningFrozen$learner(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuningFrozen-learners"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuningFrozen-learners}{}}}
\subsection{Method \code{learners()}}{
Retrieve list of trained \link[mlr3:Learner]{mlr3::Learner} objects of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuningFrozen$learners(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuningFrozen-learner_param_vals"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuningFrozen-learner_param_vals}{}}}
\subsection{Method \code{learner_param_vals()}}{
Retrieve param values of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuningFrozen$learner_param_vals(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuningFrozen-predictions"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuningFrozen-predictions}{}}}
\subsection{Method \code{predictions()}}{
Retrieve list of \link[mlr3:Prediction]{mlr3::Prediction} objects of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuningFrozen$predictions(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuningFrozen-resample_result"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuningFrozen-resample_result}{}}}
\subsection{Method \code{resample_result()}}{
Retrieve \link[mlr3:ResampleResult]{mlr3::ResampleResult} of the i-th evaluation, by position or by unique hash \code{uhash}.
\code{i} and \code{uhash} are mutually exclusive.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuningFrozen$resample_result(i = NULL, uhash = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(\code{integer(1)})\cr
The iteration value to filter for.}

\item{\code{uhash}}{(\code{logical(1)})\cr
The \code{uhash} value to filter for.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuningFrozen-print"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuningFrozen-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuningFrozen$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveAsyncTuningFrozen-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveAsyncTuningFrozen-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveAsyncTuningFrozen$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
