% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{list_md_user_instance}
\alias{list_md_user_instance}
\title{List a MotherDuck user's instance settings}
\usage{
list_md_user_instance(user_name, motherduck_token = "MOTHERDUCK_TOKEN")
}
\arguments{
\item{user_name}{A character string specifying the MotherDuck user name whose
tokens should be listed.}

\item{motherduck_token}{Character. Either the name of an environment variable containing your
MotherDuck access token (default \code{"MOTHERDUCK_TOKEN"}) or the token itself.}
}
\value{
A tibble with two columns:
\itemize{
\item \code{instance_desc}: names or descriptions of instance configuration settings.
\item \code{instance_values}: corresponding values for each configuration field.
}
}
\description{
Retrieves configuration and instance-level settings for a specified
MotherDuck user, returning the results as a tidy tibble.
}
\details{
This function calls the MotherDuck REST API endpoint
\verb{https://api.motherduck.com/v1/users/\{user_name\}/instances} to fetch
information about the user’s active DuckDB instances and their configuration
parameters.

The current authenticated user is displayed with \code{\link[=show_current_user]{show_current_user()}} for
verification.
}
\examples{
\dontrun{
# List instance settings for a specific user
instance_tbl <- list_md_user_instance(user_name ="Bob Smith")
}

}
\seealso{
Other db-api: 
\code{\link{configure_md_user_settings}()},
\code{\link{create_md_access_token}()},
\code{\link{create_md_user}()},
\code{\link{delete_md_access_token}()},
\code{\link{delete_md_user}()},
\code{\link{list_md_active_accounts}()},
\code{\link{list_md_user_tokens}()},
\code{\link{show_current_user}()}
}
\concept{db-api}
