% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/composed_projector.R
\name{vars_for_component}
\alias{vars_for_component}
\alias{vars_for_component.composed_projector}
\title{Identify Original Variables for a Specific Component}
\usage{
vars_for_component(x, k, ...)

\method{vars_for_component}{composed_projector}(x, k, tol = 1e-08, ...)
}
\arguments{
\item{x}{A projector object (e.g., \code{projector}, \code{composed_projector}).}

\item{k}{The index of the output component to query.}

\item{...}{Additional arguments passed to specific methods.}

\item{tol}{Numeric tolerance for determining non-zero coefficients. Default is 1e-8 for some methods. Passed via \code{...}.}
}
\value{
A sorted numeric vector of unique indices corresponding to the original input variables.
}
\description{
Determines which columns from the \emph{original} input space contribute
(have non-zero influence) to a \emph{specific} output component of the projector.
}
