% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{primary_hue}
\alias{primary_hue}
\alias{primary_colornum}
\alias{primary_signvector}
\alias{primary_color}
\title{Primary colors}
\usage{
primary_hue(
  set,
  type = c("all", "half_palette", "modes"),
  ineqmat = NULL,
  edo = 12,
  rounder = 10
)

primary_colornum(set, type = "all", ...)

primary_signvector(set, type = "all", ...)

primary_color(set, type = "all", nmax = 12, reconvert = FALSE, ...)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{type}{How broad of an equivalence class should be considered? May
be one of three options:
\itemize{
\item "all", the default, uses the full range of \code{\link[=scale_palette]{scale_palette()}} relationships
\item "half_palette" uses \code{\link[=scale_palette]{scale_palette()}} with \code{include_involution=FALSE}
\item "modes" uses only the n modes of \code{set}
}}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to "white," "roth", "pastel," or "rosy", giving the
\code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}},
and \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}}. For other
arrangements, the desired inequality matrix can be entered directly.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}

\item{...}{Arguments to be passed to \code{primary_hue()}}

\item{nmax}{Integer, essentially a limit to how far the function should search before giving up.
Although every real color should have a rational representation in some mod k universe, for some colors
that k must be very high. Increasing nmax makes the function run longer but might be necessary
if small chromatic universes don't produce a result. Defaults to \code{12}.}

\item{reconvert}{Boolean. Should the scale be converted to 12edo? Defaults to \code{FALSE}.}
}
\value{
A numeric vector representing a scale for \code{primary_hue()}; a
single integer for \code{primary_colornum()}; a \code{\link[=signvector]{signvector()}} for
\code{primary_signvector()}; and a list like \code{\link[=quantize_color]{quantize_color()}} for
\code{primary_color()}.
}
\description{
In traditional pitch-class set theory, concepts like normal order and
\code{\link[=primeform]{primeform()}} establish a canonical representative for each equivalence
class of pitch-class sets. It's useful to do something similar in MCT
as well: given a family of scales, such as the collection of modes or a
\code{\link[=scale_palette]{scale_palette()}}, we can define the "primary color" of the family as the
one that comes first when the scales' sign vectors are ordered lexicographically.
\code{primary_hue()} uses \code{\link[=ineqsym]{ineqsym()}} to return a specific representative of
the primary color which belongs to the same palette of hues as the input.
Because \code{primary_hue()} focuses on hues rather than colors, it may not
highlight the fact that two scales have the same primary color. Thus, for
information about broader families, \code{primary_colornum()} returns the color
number of the primary color, \code{primary_signvector()} returns the sign vector,
and \code{primary_color()} itself uses \code{\link[=quantize_color]{quantize_color()}} to return a consistent
representative of each color.
}
\examples{
major_64 <- c(0, 5, 9)
primary_hue(major_64)
primary_hue(major_64, type="modes")

viennese_trichord <- c(0, 6, 11)
# Same primary color as major_64:
apply(cbind(major_64, viennese_trichord), 2, primary_signvector)

# But a different primary hue:
primary_hue(viennese_trichord)

# Only works with representative_signvectors loaded:
primary_colornum(major_64) == primary_colornum(viennese_trichord)

primary_color(major_64)
primary_color(viennese_trichord)

}
