% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{Scalar interval matrix}
\usage{
sim(set, edo = 12)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Numeric \code{n} by \code{n} matrix where \code{n} is the number of notes in \code{set}
}
\description{
As defined by Tymoczko 2008 ("Scale Theory, Serial Theory and Voice Leading")
\url{https://onlinelibrary.wiley.com/doi/10.1111/j.1468-2249.2008.00257.x},
the \strong{s}calar \strong{i}nterval \strong{m}atrix represents the "rotations" of a set,
transposed to begin on 0, in its columns. Its nth row represents the
specific intervals which represent its generic interval of size n.
}
\examples{
diatonic_modes <- sim(c(0, 2, 4, 5, 7, 9, 11))
print(diatonic_modes)

miyakobushi_modes <- sim(c(0, 1, 5, 7, 8)) # rows show trivalence
print(miyakobushi_modes)
}
