% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_img.R
\docType{methods}
\name{separate_img-methods}
\alias{separate_img-methods}
\alias{separate_img}
\alias{separate_img,nifti-method}
\alias{separate_img,array-method}
\alias{separate_img,ANY-method}
\alias{separate_img,factor-method}
\alias{separate_img,character-method}
\alias{separate_img,list-method}
\title{Separate Labeled Image into Multiple Binary Images}
\usage{
separate_img(img, levels = NULL, drop_zero = TRUE)

\S4method{separate_img}{nifti}(img, levels = NULL, drop_zero = TRUE)

\S4method{separate_img}{array}(img, levels = NULL, drop_zero = TRUE)

\S4method{separate_img}{ANY}(img, levels = NULL, drop_zero = TRUE)

\S4method{separate_img}{factor}(img, levels = NULL, drop_zero = TRUE)

\S4method{separate_img}{character}(img, levels = NULL, drop_zero = TRUE)

\S4method{separate_img}{list}(img, levels = NULL, drop_zero = TRUE)
}
\arguments{
\item{img}{character path of image or 
an object of class \code{nifti}, or list of images}

\item{levels}{if \code{levels} is given, then the separation is only
done for those levels and not unique values of the image.}

\item{drop_zero}{Should zeroes be dropped from the labels?  Zero 
usually denotes background or non-interesting voxels}
}
\value{
A \code{nifti} object (or list of them) or class of 
object passed in if not specified
}
\description{
Takes in an image, gets the unique values, then 
creates a list of binary images for each one of those values.
}
\note{
Exact equalling is using \code{==}
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rpois(prod(dims), lambda = 2), dim = dims)
nim = oro.nifti::nifti(arr)
simg = separate_img(nim)
simg_arr = separate_img(arr)
slist = lapply(simg, function(x) array(x, dim(x)))
testthat::expect_equal(slist, simg_arr)

rnifti = RNifti::asNifti(nim)
timg = tempimg(nim)
limg = list(factor(timg), factor(timg))
func = separate_img
func(arr)
func(nim)
func(rnifti)
func(timg)
func(limg)
}
