% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_nflseedR.R
\name{summary.nflseedR_simulation}
\alias{summary.nflseedR_simulation}
\title{Compute Pretty Simulations Summary Table}
\usage{
\method{summary}{nflseedR_simulation}(object, ...)
}
\arguments{
\item{object}{an object for which a summary is desired.}

\item{...}{additional arguments passed on to the methods (currently not used).}
}
\description{
Uses the R package gt to create a pretty html table of the
nflseedR simulation summary data frame.
}
\section{Output of below example}{

\if{html}{\figure{summary_tbl.png}{options: width=75\%}}
}

\examples{
\donttest{
library(nflseedR)
# set seed for recreation,
# internal parallelization requires a L'Ecuyer-CMRG random number generator
set.seed(19980310, kind = "L'Ecuyer-CMRG")

# Simulate the season 20 times in 1 round
sim <- nflseedR::simulate_nfl(
  nfl_season = 2021,
  fresh_season = TRUE,
  simulations = 20
)

# Create Summary Tables
tbl <- summary(sim)

# The output of tbl is given in the above image.
}
}
