% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIndirect.R
\name{addIndirect}
\alias{addIndirect}
\title{Add an indirect response model to a PK model}
\usage{
addIndirect(
  ui,
  stim = c("in", "out"),
  inhib = c("in", "out"),
  hill = FALSE,
  ek = "Ek",
  ik = "Ik",
  emax = "Emax",
  ec50 = "EC50",
  imax = "Imax",
  ic50 = "IC50",
  kin = "kin",
  kout = "kout",
  g = "g",
  cc = "Cc",
  R = "R",
  effect = "effect"
)
}
\arguments{
\item{ui}{rxode2 model}

\item{stim}{what type of stimulation indirect response model:

- `in`: stimulation of input

- `out`: stimulation of output}

\item{inhib}{what type of inhibition indirect response model:

- `in`: inhibition of input

- `out`: inhibition of output}

\item{hill}{Boolean stating if a hill sigmoid coefficient will be added}

\item{ek}{simulation linear constant}

\item{ik}{inhibition linear constant}

\item{emax}{Emax parameter}

\item{ec50}{EC50 parameter}

\item{imax}{maximum inhibitory concentration}

\item{ic50}{concentration where half of the Imax occurs}

\item{kin}{this is the kin parameter name}

\item{kout}{this is the kout parameter name}

\item{g}{hill coefficient}

\item{cc}{the concentration value}

\item{R}{drug response compartment}

\item{effect}{the effect variable that will be modeled}
}
\value{
pk model with indirect response model added
}
\description{
Add an indirect response model to a PK model
}
\examples{

readModelDb("PK_2cmt_no_depot") |>
  addIndirect(stim="in",hill=TRUE)

readModelDb("PK_2cmt_no_depot") |>
  addIndirect(inhib="out", imax=1)
}
\seealso{
Other Indirect response: 
\code{\link{addIndirectLin}()},
\code{\link{convertKinR0}()}
}
\author{
Matthew L. Fidler
}
\concept{Indirect response}
