% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGenotype.R
\name{addGenotype}
\alias{addGenotype}
\title{Add genotype data to pedigree file}
\usage{
addGenotype(ped, genotype)
}
\arguments{
\item{ped}{pedigree dataframe. \code{ped} is to be provided by
\code{qcStudbook} so it is not checked.}

\item{genotype}{genotype dataframe. \code{genotype} is to be provided by
\code{checkGenotypeFile} so it is not checked.}
}
\value{
A pedigree object with genotype data added.
}
\description{
Assumes genotype has been opened by \code{checkGenotypeFile}
}
\examples{
library(nprcgenekeepr)
rhesusPedigree <- nprcgenekeepr::rhesusPedigree
rhesusGenotypes <- nprcgenekeepr::rhesusGenotypes
pedWithGenotypes <- addGenotype(
  ped = rhesusPedigree,
  genotype = rhesusGenotypes
)

}
