% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addLayerDictionaryEntry.R
\name{addLayerDictionaryEntry}
\alias{addLayerDictionaryEntry}
\title{Adds an entry to a layer dictionary}
\usage{
addLayerDictionaryEntry(labbcat.url, layer.id, key, entry)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{layer.id}{The ID of the layer with a dictionary configured to manage it.}

\item{key}{The key (word) in the dictionary to add an entry for.}

\item{entry}{The value (definition) for the given key.}
}
\value{
NULL if the entry was added, or a list of error messages if not.
}
\description{
This function adds a new entry to the dictionary that manages a given layer,
and updates all affected tokens in the corpus. Words can have multiple entries.
}
\details{
You must have edit privileges in LaBB-CAT in order to be able to use this function.
}
\examples{
\dontrun{
## Add a pronunciation for the word "robert" to the phonemes layer dictionary
addLayerDictionaryEntry(labbcat.url, "phonemes", "robert", "'rQ-b@t")
}

}
\seealso{
Other dictionary functions: 
\code{\link{addDictionaryEntry}()},
\code{\link{deleteLexicon}()},
\code{\link{getDictionaries}()},
\code{\link{getDictionaryEntries}()},
\code{\link{loadLexicon}()},
\code{\link{removeDictionaryEntry}()},
\code{\link{removeLayerDictionaryEntry}()}
}
\concept{dictionary functions}
\keyword{annotation}
\keyword{layer}
