% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countAnnotations.R
\name{countAnnotations}
\alias{countAnnotations}
\title{Gets the number of annotations on the given layer of the given transcript}
\usage{
countAnnotations(labbcat.url, id, layer.id, max.ordinal = NULL)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A transcript ID (i.e. transcript name)}

\item{layer.id}{A layer ID}

\item{max.ordinal}{The maximum ordinal for the counted annotations. e.g. a max.ordinal
of 1 will ensure that only the first annotation for each parent is returned. If
max.ordinal is null, then all annotations are counted, regardless of their ordinal.}
}
\value{
The number of annotations on that layer
}
\description{
Returns the number of annotations on the given layer of the given
transcript.
}
\examples{
\dontrun{
## Count the number of words in UC427_ViktoriaPapp_A_ENG.eaf
token.count <- countAnnotations(labbcat.url, "UC427_ViktoriaPapp_A_ENG.eaf", "orthography")
}

}
\seealso{
\itemize{
\item \link{getTranscriptIds}
\item \link{getTranscriptIdsInCorpus}
\item \link{getTranscriptIdsWithParticipant}
}
}
\keyword{transcript}
