% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_slide_manip.R
\name{slide_visible<-}
\alias{slide_visible<-}
\alias{slide_visible}
\title{Get or set slide visibility}
\usage{
slide_visible(x) <- value

slide_visible(x, hide = NULL, show = NULL)
}
\arguments{
\item{x}{An \code{rpptx} object.}

\item{value}{Boolean vector with slide visibilities.}

\item{hide, show}{Indexes of slides to hide or show.}
}
\value{
Boolean vector with slide visibilities or \code{rpptx} object if changes are made to the object.
}
\description{
PPTX slides can be visible or hidden. This function gets or sets the visibility of slides.
}
\examples{
path <- system.file("doc_examples/example.pptx", package = "officer")
x <- read_pptx(path)

slide_visible(x) # get slide visibilities

x <- slide_visible(x, hide = 1:2) # hide slides 1 and 2
x <- slide_visible(x, show = 1:2) # make slides 1 and 2 visible
x <- slide_visible(x, show = 1:2, hide = 3)

slide_visible(x) <- FALSE # hide all slides
slide_visible(x) <- c(TRUE, FALSE, TRUE) # set each slide separately
slide_visible(x) <- c(TRUE, FALSE) # warns that rhs values are recycled

slide_visible(x)[2] <- TRUE # set 2nd slide to visible
slide_visible(x)[c(1, 3)] <- FALSE # 1st and 3rd slide
slide_visible(x)[c(1, 3)] <- c(FALSE, FALSE) # identical

}
