% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_section.R
\name{body_end_section_landscape}
\alias{body_end_section_landscape}
\title{Add landscape section}
\usage{
body_end_section_landscape(x, w = 16838/1440, h = 11906/1440)
}
\arguments{
\item{x}{an rdocx object}

\item{w, h}{page width, page height (in inches)}
}
\description{
A section with landscape orientation is added to the document.
}
\examples{
str1 <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit."
str1 <- rep(str1, 5)
str1 <- paste(str1, collapse = " ")

doc_1 <- read_docx()
doc_1 <- body_add_par(doc_1, value = str1, style = "Normal")
doc_1 <- body_end_section_landscape(doc_1)

print(doc_1, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for Word sections: 
\code{\link{body_end_block_section}()},
\code{\link{body_end_section_columns}()},
\code{\link{body_end_section_columns_landscape}()},
\code{\link{body_end_section_continuous}()},
\code{\link{body_end_section_portrait}()},
\code{\link{body_set_default_section}()}
}
\concept{functions for Word sections}
