% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{createLogFile}
\alias{createLogFile}
\title{Create a log file}
\usage{
createLogFile(logFile = here::here("log_{date}_{time}"))
}
\arguments{
\item{logFile}{File path to write logging messages. You can use '\{date\}'
and '\{time\}' to add the date and time in the log file name.}
}
\value{
Invisible TRUE if logger was created correctly.
}
\description{
Create a log file
}
\examples{
library(dplyr)

logFile <- tempfile(pattern = "log_{date}_{time}", fileext = ".txt")
createLogFile(logFile = logFile)

logMessage("Starting analysis")
1 + 1
logMessage("Analysis finished")

res <- summariseLogFile()

glimpse(res)

tidy(res)

}
