% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_officer_object.R
\name{fetch_officer_object}
\alias{fetch_officer_object}
\title{Extracts Officer Object From Onbrand Report Object}
\usage{
fetch_officer_object(obnd, verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned onbrand
object.}
}
\value{
List with the following elements
\itemize{
\item{isgood}: Boolean variable indicating success or failure
\item{rpt}: Officer object
\item{msgs}: Vector of messages
}
}
\description{
If you need modify the onbrand report object directly with
officer functions you can use this function to extract the report object
from the onbrand object.
}
\examples{

obnd = read_template(
      template = file.path(system.file(package="onbrand"), "templates", "report.pptx"),
      mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

rpt = fetch_officer_object(obnd)$rpt

}
\seealso{
\code{\link{set_officer_object}}
}
