% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOptimalConditionalError.R
\name{getOptimalConditionalError}
\alias{getOptimalConditionalError}
\title{Calculate the Optimal Conditional Error}
\usage{
getOptimalConditionalError(firstStagePValue, design)
}
\arguments{
\item{firstStagePValue}{First-stage p-value or p-values. Must be a numeric vector between 0 and 1.}

\item{design}{An object of class \code{TrialDesignOptimalConditionalError} created by \code{getDesignOptimalConditionalErrorFunction()}. Contains all necessary arguments to calculate the optimal conditional error function for the specified case.}
}
\value{
Value of the optimal conditional error function.
}
\description{
Calculate the Optimal Conditional Error
}
\details{
The optimal conditional error \eqn{\alpha_2} given a first-stage p-value \eqn{p_1} is calculated as:
\deqn{\alpha_2(p_1)=\psi(-e^{c_0} \cdot \frac{\Delta_1^2}{l(p_1)}).}

The level constant \eqn{c_0} as well as the specification of the effect size \eqn{\Delta_1} and the likelihood ratio \eqn{l(p_1)}
must be contained in the \code{design} object (see \code{?getDesignOptimalConditionalErrorFunction}).
Early stopping rules are supported, i.e., for \eqn{p_1 \leq \alpha_1}, the returned conditional error is 1 and for \eqn{p_1 > \alpha_0}, the returned conditional error is 0.
}
\examples{
# Create a design
design <- getDesignOptimalConditionalErrorFunction(
alpha = 0.025, alpha1 = 0.001, alpha0 = 0.5, conditionalPower = 0.9,
delta1 = 0.5, firstStageInformation = 40, useInterimEstimate = FALSE,
likelihoodRatioDistribution = "fixed", deltaLR = 0.5)

# Calculate optimal conditional error
getOptimalConditionalError(
firstStagePValue = c(0.1, 0.2, 0.3), design = design
)
}
\references{
Brannath, W. & Bauer, P. (2004). Optimal conditional error functions for the control of conditional power. Biometrics. https://www.jstor.org/stable/3695393
}
\seealso{
\code{\link[=getDesignOptimalConditionalErrorFunction]{getDesignOptimalConditionalErrorFunction()}}
}
