% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{orbital_json_write}
\alias{orbital_json_write}
\title{Save orbital object as json file}
\usage{
orbital_json_write(x, path)
}
\arguments{
\item{x}{An \link{orbital} object.}

\item{path}{file on disk.}
}
\value{
Nothing.
}
\description{
Saving an orbital object to disk in a human and machine readable way.
}
\details{
The structure of the resulting JSON file allows for easy reading, both by
orbital itself with \code{\link[=orbital_json_read]{orbital_json_read()}}, but potentially by other packages
and langauges. The file is versioned by the \code{version} field to allow for
changes why being backwards combatible with older file versions.
}
\examples{
\dontshow{if (rlang::is_installed(c("jsonlite", "recipes", "tidypredict", "workflows"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

tmp_file <- tempfile()

orbital_json_write(orbital_obj, tmp_file)

readLines(tmp_file)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=orbital_json_read]{orbital_json_read()}}
}
