% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{orderly_config}
\alias{orderly_config}
\alias{orderly_config_}
\title{Retrieve orderly config object.}
\usage{
orderly_config(root = NULL, locate = TRUE)
}
\arguments{
\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}
}
\value{
An R6 object representing the orderly config.
}
\description{
Retrieve orderly config object.
}
\examples{
# The orderly demo, with lots of potential reports:
path <- orderly::orderly_example("demo")

orderly::orderly_config(path)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{root}}{Root dir of the orderly repository}

\item{\code{raw}}{The raw orderly config yaml}

\item{\code{destination}}{DB connection configuration for where
to store orderly output database. Defaults to local SQLite
db \code{orderly.sqlite}}

\item{\code{fields}}{Configuration of fields in reports, specifying
which are required}

\item{\code{remote}}{Configuration of remote sources i.e. shared
copy of orderly on a remote machine}

\item{\code{vault}}{Vault server connection information}

\item{\code{global_resources}}{Path to dir containing global resources.}

\item{\code{changelog}}{Changelog type configuration}

\item{\code{tags}}{List of available tags for orderly reports.}

\item{\code{database}}{Database configuration specifying driver and
connection args for (possibly multiple) databases}

\item{\code{archive_version}}{Orderly version number of the archive}

\item{\code{run_options}}{List of run options}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{orderly_config_$new()}}
\item \href{#method-server_options}{\code{orderly_config_$server_options()}}
\item \href{#method-add_run_option}{\code{orderly_config_$add_run_option()}}
\item \href{#method-get_run_option}{\code{orderly_config_$get_run_option()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object representing orderly config
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{orderly_config_$new(root, validate = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{root}}{Root dir of the orderly repository}

\item{\code{validate}}{If TRUE migrate cfg to handle any
format changes and validate structure if well formed
for each of the cfg fields}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-server_options"></a>}}
\if{latex}{\out{\hypertarget{method-server_options}{}}}
\subsection{Method \code{server_options()}}{
Get connection options for the current server. This is
the details from the "remote" section for the server
being run on. Server identified via env var
\code{ORDERLY_API_SERVER_IDENTITY}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{orderly_config_$server_options()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Options for current server if can be identified,
otherwise NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_run_option"></a>}}
\if{latex}{\out{\hypertarget{method-add_run_option}{}}}
\subsection{Method \code{add_run_option()}}{
Add a key-value pair run option
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{orderly_config_$add_run_option(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of run option}

\item{\code{value}}{Value for run option}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_run_option"></a>}}
\if{latex}{\out{\hypertarget{method-get_run_option}{}}}
\subsection{Method \code{get_run_option()}}{
Retrieve value of a run option
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{orderly_config_$get_run_option(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of run option}
}
\if{html}{\out{</div>}}
}
}
}
