% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-ns.r
\name{sim.twocamera}
\alias{sim.twocamera}
\title{Simulating data from two-camera aerial surveys.}
\usage{
sim.twocamera(pars, d, w, b, l, tau, parents = NULL)
}
\arguments{
\item{pars}{A vector containing elements named \code{D.2D},
\code{kappa}, and \code{sigma}, providing values of animal
density (animals per square km), average duration of surface
phase (s), and dispersion (km).}

\item{d}{The length of the transect flown (in km).}

\item{w}{The distance from the transect to which detection of
individuals on the surface is certain. This is equivalent to
the half-width of the detection zone.}

\item{b}{The distance from the transect to the edge of the area of
interest. Conceptually, the distance between the transect and
the furthest distance a whale could be on the passing of the
first camera and plausibly move into the detection zone by the
passing of the second camera.}

\item{l}{The lag between cameras (in seconds).}

\item{tau}{Mean dive-cycle duration (in seconds).}

\item{parents}{An optional vector containing the parent locations
for all animals within the area of interest, given in distance
along the transect (in km). If this is provided, then the
parameter \code{D.2D} is not required in \code{pars}. If this
is not provided, then parent locations are generated from a
homogeneous Poisson point process with intensity \code{D.2D}.}
}
\value{
A list. The first component gives the distance along the
    transect of detected individuals. The second gives the parent
    locations. The third identifies which parent location generated
    each detected individual. The fourth gives the distance from
    the transect centre line of the detection location. The fifth
    provides observed sibling information.
}
\description{
Simulating data from two-camera aerial surveys.
}
\examples{
twocamera.data <- sim.twocamera(c(D.2D = 1.3, kappa = 27, sigma = 0.02), d = 500,
                                w = 0.175, b = 0.5, l = 20, tau = 110)

}
