% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distPlot.R
\name{distributionPlot}
\alias{distributionPlot}
\title{Function for plotting iterations of posterior distributions}
\usage{
distributionPlot(
  fits,
  form,
  df,
  priors = NULL,
  params = NULL,
  maxTime = NULL,
  patch = TRUE
)
}
\arguments{
\item{fits}{A list of brmsfit objects following the same data over time.
Currently checkpointing is not supported.}

\item{form}{A formula describing the growth model similar to \code{\link{growthSS}}
and \code{\link{brmPlot}} such as: outcome ~ predictor |individual/group}

\item{df}{data used to fit models (this is used to plot each subject's trend line).}

\item{priors}{a named list of samples from the prior distributions for each parameter in
\code{params}. This is only used if sample_prior=FALSE in the brmsfit object.
If left NULL then no prior is included.}

\item{params}{a vector of parameters to include distribution plots of.
Defaults to NULL which will use all parameters from the top level model.}

\item{maxTime}{Optional parameter to designate a max time not observed in the models so far}

\item{patch}{Logical, should a patchwork plot be returned or should lists of ggplots be returned?}
}
\value{
A ggplot or a list of ggplots (depending on patch).
}
\description{
Function for plotting iterations of posterior distributions
}
\examples{
\donttest{
f <- "https://raw.githubusercontent.com/joshqsumner/pcvrTestData/main/brmsFits.rdata"
tryCatch(
  {
    print(load(url(f)))
    library(brms)
    library(ggplot2)
    library(patchwork)
    fits <- list(fit_3, fit_15)
    form <- y~time | id / group
    priors <- list(
      "phi1" = rlnorm(2000, log(130), 0.25),
      "phi2" = rlnorm(2000, log(12), 0.25),
      "phi3" = rlnorm(2000, log(3), 0.25)
    )
    params <- c("A", "B", "C")
    d <- simdf
    maxTime <- NULL
    patch <- TRUE
    from3to25 <- list(
      fit_3, fit_5, fit_7, fit_9, fit_11,
      fit_13, fit_15, fit_17, fit_19, fit_21, fit_23, fit_25
    )
    distributionPlot(
      fits = from3to25, form = y ~ time | id / group,
      params = params, d = d, priors = priors, patch = FALSE
    )
    distributionPlot(
      fits = from3to25, form = y ~ time | id / group,
      params = params, d = d, patch = FALSE
    )
  },
  error = function(e) {
    message(e)
  }
)
}
## End(Not run)
}
\keyword{Bayesian}
\keyword{brms}
