% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcvrss.R
\docType{class}
\name{pcvrss-class}
\alias{pcvrss-class}
\alias{pcvrss}
\title{Class \code{pcvrss} for models specified in \code{pcvr}.}
\description{
Models specified by \link{growthSS} or \link{mvSS} are represented by a \code{pcvrss} object,
which contains the model type, formulas, starting values or priors, the data for the model
to use, and the model backend to use.
}
\details{
See \code{methods(class = "pcvrss")} for an overview of available methods.
}
\section{Slots}{

\describe{
\item{\code{formula}}{The formula that will be used to fit the model.}

\item{\code{prior}}{Priors if the model is a Bayesian model (ie using the brms backend).}

\item{\code{initfun}}{Initialization function if the model is a Bayesian model.}

\item{\code{df}}{The data that will be used to fit the model.}

\item{\code{family}}{The model family, currently only used in the brms backend.}

\item{\code{pcvrForm}}{The formula that was specified in \link{growthSS} and used in other pcvr functions.}

\item{\code{type}}{The model backend.}

\item{\code{model}}{The name of the main growth formula.}

\item{\code{call}}{The call to \link{growthSS} or \link{mvSS}.}

\item{\code{start}}{Starting values for frequentist models.}

\item{\code{taus}}{Quantiles for nlrq/rq models.}
}}

\seealso{
\code{\link{growthSS}},
  \code{\link{mvSS}}
}
