% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_residuals.R
\name{simulate_residuals}
\alias{simulate_residuals}
\alias{residuals.performance_simres}
\title{Simulate randomized quantile residuals from a model}
\usage{
simulate_residuals(x, iterations = 250, ...)

\method{residuals}{performance_simres}(object, quantile_function = NULL, outlier_values = NULL, ...)
}
\arguments{
\item{x}{A model object.}

\item{iterations}{Number of simulations to run.}

\item{...}{Arguments passed on to \code{\link[DHARMa:simulateResiduals]{DHARMa::simulateResiduals()}}.}

\item{object}{A \code{performance_simres} object, as returned by \code{simulate_residuals()}.}

\item{quantile_function}{A function to apply to the residuals. If \code{NULL}, the
residuals are returned as is. If not \code{NULL}, the residuals are passed to this
function. This is useful for returning normally distributed residuals, for
example: \code{residuals(x, quantile_function = qnorm)}.}

\item{outlier_values}{A vector of length 2, specifying the values to replace
\code{-Inf} and \code{Inf} with, respectively.}
}
\value{
Simulated residuals, which can be further processed with
\code{\link[=check_residuals]{check_residuals()}}. The returned object is of class \code{DHARMa} and
\code{performance_simres}.
}
\description{
Returns simulated residuals from a model. This is useful for
checking the uniformity of residuals, in particular for non-Gaussian models,
where the residuals are not expected to be normally distributed.
}
\details{
This function is a small wrapper around \code{\link[DHARMa:simulateResiduals]{DHARMa::simulateResiduals()}}.
It basically only sets \code{plot = FALSE} and adds an additional class attribute
(\code{"performance_sim_res"}), which allows using the DHARMa object in own plotting
functions from the \strong{see} package. See also \code{vignette("DHARMa")}. There is a
\code{plot()} method to visualize the distribution of the residuals.
}
\section{Tests based on simulated residuals}{

For certain models, resp. model from certain families, tests like
\code{\link[=check_zeroinflation]{check_zeroinflation()}} or \code{\link[=check_overdispersion]{check_overdispersion()}} are based on
simulated residuals. These are usually more accurate for such tests than
the traditionally used Pearson residuals. However, when simulating from more
complex models, such as mixed models or models with zero-inflation, there are
several important considerations. \code{simulate_residuals()} relies on
\code{\link[DHARMa:simulateResiduals]{DHARMa::simulateResiduals()}}, and additional arguments specified in \code{...}
are passed further down to that function. The defaults in DHARMa are set on
the most conservative option that works for all models. However, in many
cases, the help advises to use different settings in particular situations
or for particular models. It is recommended to read the 'Details' in
\code{?DHARMa::simulateResiduals} closely to understand the implications of the
simulation process and which arguments should be modified to get the most
accurate results.
}

\examples{
\dontshow{if (require("DHARMa")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
simulate_residuals(m)

# extract residuals
head(residuals(simulate_residuals(m)))
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Hartig, F., & Lohse, L. (2022). DHARMa: Residual Diagnostics for Hierarchical
(Multi-Level / Mixed) Regression Models (Version 0.4.5). Retrieved from
https://CRAN.R-project.org/package=DHARMa
\item Dunn, P. K., & Smyth, G. K. (1996). Randomized Quantile Residuals. Journal
of Computational and Graphical Statistics, 5(3), 236. \doi{10.2307/1390802}
}
}
\seealso{
\code{\link[=check_residuals]{check_residuals()}}, \code{\link[=check_zeroinflation]{check_zeroinflation()}},
\code{\link[=check_overdispersion]{check_overdispersion()}} and \code{\link[=check_predictions]{check_predictions()}}. See also
\code{\link[see:plot.see_performance_simres]{see::plot.see_performance_simres()}} for options to customize the plot.
}
