% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_ecoregions.R
\name{pm_list_ecoregions}
\alias{pm_list_ecoregions}
\title{Display ecoregion metadata for Peruvian mammals}
\usage{
pm_list_ecoregions(include_endemic = FALSE)
}
\arguments{
\item{include_endemic}{Logical. If \code{TRUE}, includes columns showing
the number and percentage of endemic species per ecoregion. Default is
\code{FALSE}.}
}
\value{
A tibble with one row per ecoregion, arranged in descending order
by species richness, with the following columns:
\describe{
\item{ecoregion_code}{Abbreviated ecoregion code (e.g., "SB", "YUN")}
\item{ecoregion_label}{Full ecoregion name in Spanish}
\item{n_species}{Total number of mammal species recorded in the ecoregion}
\item{pct_species}{Percentage of Peru's total mammal diversity (0-100)}
\item{n_endemic}{(Only if \code{include_endemic = TRUE}) Number of
endemic species in the ecoregion}
\item{pct_endemic}{(Only if \code{include_endemic = TRUE}) Percentage of
endemic species relative to total species in the ecoregion (0-100)}
}
}
\description{
Displays summary information about the ecoregions used in the Peruvian
mammal backbone. Ecoregions follow the Brack-Egg (1986) classification
system used in Peruvian biogeography to describe the distribution of
mammal species across different ecological regions.
}
\details{
The ecoregion classification follows Brack-Egg (1986), a widely-used
biogeographic framework for Peru that recognizes 10 distinct ecological
regions based on climate, vegetation, and elevation. This classification
is used in Pacheco et al. (2021) to document the distribution patterns
of Peruvian mammals.

The function prints a formatted summary to the console and invisibly
returns the complete data for further analysis.
}
\examples{
# Display ecoregion information
pm_list_ecoregions()

# Include endemic species information
 pm_list_ecoregions(include_endemic = TRUE)

# Access the data for further analysis
ecoregion_data <- pm_list_ecoregions()

# Ecoregions with highest species richness
ecoregion_data

}
\references{
Brack-Egg, A. (1986). Ecología de un país complejo. In J. Mejía Baca (Ed.),
Gran Geografía del Perú: Naturaleza y Hombre (Vol. 2, pp. 175-319).
Barcelona: Manfer-Mejía Baca.
}
\seealso{
\code{\link{peru_mammals_ecoregions_meta}} for the complete ecoregion metadata,
\code{\link{peru_mammals_ecoregions}} for species-ecoregion associations,
\code{\link{pm_by_ecoregion}()} to filter species by ecoregion,
\code{\link{pm_ecoregion_summary}()} for species richness summaries by ecoregion.
}
