% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varsDifferentTypes.R
\name{varsDifferentTypes}
\alias{varsDifferentTypes}
\title{Identify Variables of Different Types.}
\usage{
varsDifferentTypes(df1, df2)
}
\arguments{
\item{df1}{dataframe 1 (object)}

\item{df2}{dataframe 2 (object)}
}
\value{
Dataframe with columns for the variable name, the variable type in \code{df1}
and the variable type in \code{df2}.
}
\description{
Identifies the variables in common across two dataframes that have different
types.
}
\details{
Identifies the variables that have the same name across two dataframes that
have different types, which can pose challenges for merging two dataframes.
}
\examples{
# Prepare Data
df1 <- data.frame(
  A = 1:3,
  B = 2:4,
  C = 3:5
)

df2 <- data.frame(
  A = as.character(1:3),
  B = 2:4,
  C = as.factor(3:5)
)

# Check if any rows are not NA
varsDifferentTypes(df1, df2)
}
\seealso{
Other dataManipulation: 
\code{\link{columnBindFill}()},
\code{\link{convert.magic}()},
\code{\link{dropColsWithAllNA}()},
\code{\link{dropRowsWithAllNA}()}
}
\concept{dataManipulation}
