% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullclines.R
\name{nullclines}
\alias{nullclines}
\title{Nullclines}
\usage{
nullclines(
  deriv,
  xlim,
  ylim,
  parameters = NULL,
  system = "two.dim",
  points = 101,
  col = c("blue", "cyan"),
  add = TRUE,
  add.legend = TRUE,
  state.names = if (system == "two.dim") c("x", "y") else "y",
  ...
)
}
\arguments{
\item{deriv}{A function computing the derivative at a point for the ODE
system to be analysed. Discussion of the required structure of these
functions can be found in the package vignette, or in the help file for the
function \code{\link[deSolve]{ode}}.}

\item{xlim}{In the case of a two-dimensional system, this sets the limits of
the first dependent variable in which gradient reflecting line segments
should be plotted. In the case of a one-dimensional system, this sets the
limits of the independent variable in which these line segments should be
plotted. Should be a \code{\link[base]{numeric}} \code{\link[base]{vector}}
of \code{\link[base]{length}} two.}

\item{ylim}{In the case of a two-dimensional system this sets the limits of
the second dependent variable in which gradient reflecting line segments
should be plotted. In the case of a one-dimensional system, this sets the
limits of the dependent variable in which these line segments should be
plotted. Should be a \code{\link[base]{numeric}} \code{\link[base]{vector}}
of \code{\link[base]{length}} two.}

\item{parameters}{Parameters of the ODE system, to be passed to \code{deriv}.
Supplied as a \code{\link[base]{numeric}} \code{\link[base]{vector}}; the
order of the parameters can be found from the \code{deriv} file. Defaults to
\code{NULL}.}

\item{system}{Set to either \code{"one.dim"} or \code{"two.dim"} to indicate
the type of system being analysed. Defaults to \code{"two.dim"}.}

\item{points}{Sets the density at which derivatives are computed;
\code{points} x \code{points} derivatives will be computed. Levels of zero
gradient are identified using these computations and the function
\code{\link[graphics]{contour}}. Increasing the value of points improves
identification of nullclines, but increases computation time. Defaults to
\code{101}.}

\item{col}{In the case of a two-dimensional system, sets the colours used
for the x- and y-nullclines. In the case of a one-dimensional system, sets
the colour of the lines plotted horizontally along the equilibria. Should be
a \code{\link[base]{character}} \code{\link[base]{vector}} of
\code{\link[base]{length}} two. Will be reset accordingly if it is of the
wrong \code{\link[base]{length}}. Defaults to \code{c("blue", "cyan")}.}

\item{add}{Logical. If \code{TRUE}, the nullclines are added to an existing
plot. If \code{FALSE}, a new plot is created. Defaults to \code{TRUE}.}

\item{add.legend}{Logical. If \code{TRUE}, a \code{\link[graphics]{legend}}
is added to the plots. Defaults to \code{TRUE}.}

\item{state.names}{The state names for \code{\link[deSolve]{ode}} functions
that do not use positional states.}

\item{\dots}{Additional arguments to be passed to either
\code{\link[graphics]{plot}} or \code{\link[graphics]{contour}}.}
}
\value{
Returns a \code{\link[base]{list}} with the following components (the
exact make up is dependent on the value of \code{system}):
\item{add}{As per input.}
\item{add.legend}{As per input.}
\item{col}{As per input, but with possible editing if a
\code{\link[base]{character}} \code{\link[base]{vector}} of the wrong
\code{\link[base]{length}} was supplied.}
\item{deriv}{As per input.}
\item{dx}{A \code{\link[base]{numeric}} \code{\link[base]{matrix}}. In the
case of a two-dimensional system, the values of the derivative of the first
dependent derivative at all evaluated points.}
\item{dy}{A \code{\link[base]{numeric}} \code{\link[base]{matrix}}. In the
case of a two-dimensional system, the values of the derivative of the second
dependent variable at all evaluated points. In the case of a one-dimensional
system, the values of the derivative of the dependent variable at all
evaluated points.}
\item{parameters}{As per input.}
\item{points}{As per input.}
\item{system}{As per input.}
\item{x}{A \code{\link[base]{numeric}} \code{\link[base]{vector}}. In the
case of a two-dimensional system, the values of the first dependent variable
at which the derivatives were computed. In the case of a one-dimensional
system, the values of the independent variable at which the derivatives were
computed.}
\item{xlim}{As per input.}
\item{y}{A \code{\link[base]{numeric}} \code{\link[base]{vector}}. In the
case of a two-dimensional system, the of values of the second dependent
variable at which the derivatives were computed. In the case of a
one-dimensional system, the values of the dependent variable at which the
derivatives were computed.}
\item{ylim}{As per input.}
}
\description{
Plots nullclines for two-dimensional autonomous ODE systems. Can also be used
to plot horizontal lines at equilibrium points for one-dimensional autonomous
ODE systems.
}
\note{
In order to ensure a nullcline is plotted, set \code{xlim} and
\code{ylim} strictly enclosing its location. For example, to ensure a
nullcline is plotted along x = 0, set \code{ylim} to, e.g., begin at -1.
}
\examples{
# Plot the flow field, nullclines and several trajectories for the
# one-dimensional autonomous ODE system logistic.
logistic_flowField  <- flowField(logistic,
                                 xlim       = c(0, 5),
                                 ylim       = c(-1, 3),
                                 parameters = c(1, 2),
                                 points     = 21,
                                 system     = "one.dim",
                                 add        = FALSE)
logistic_nullclines <- nullclines(logistic,
                                  xlim       = c(0, 5),
                                  ylim       = c(-1, 3),
                                  parameters = c(1, 2),
                                  system     = "one.dim")
logistic_trajectory <- trajectory(logistic,
                                  y0         = c(-0.5, 0.5, 1.5, 2.5),
                                  tlim       = c(0, 5),
                                  parameters = c(1, 2),
                                  system     = "one.dim")

# Plot the velocity field, nullclines and several trajectories for the
# two-dimensional autonomous ODE system simplePendulum.
simplePendulum_flowField  <- flowField(simplePendulum,
                                       xlim       = c(-7, 7),
                                       ylim       = c(-7, 7),
                                       parameters = 5,
                                       points     = 19,
                                       add        = FALSE)
y0                        <- matrix(c(0, 1, 0, 4, -6, 1, 5, 0.5, 0, -3),
                                    5, 2, byrow = TRUE)
\donttest{
simplePendulum_nullclines <- nullclines(simplePendulum,
                                        xlim       = c(-7, 7),
                                        ylim       = c(-7, 7),
                                        parameters = 5,
                                        points     = 500)
}
simplePendulum_trajectory <- trajectory(simplePendulum,
                                        y0         = y0,
                                        tlim       = c(0, 10),
                                        parameters = 5)
}
\seealso{
\code{\link[graphics]{contour}}, \code{\link[graphics]{plot}}
}
\author{
Michael J Grayling
}
