% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.absorptance.R
\name{absorptance_spct}
\alias{absorptance_spct}
\title{Calculate absorptance from spectral absorptance.}
\usage{
absorptance_spct(spct, w.band, quantity, wb.trim, use.hinges, naming, ...)
}
\arguments{
\item{spct}{object_spct}

\item{w.band}{waveband or list of waveband objects or a numeric vector of
length two. The waveband(s) determine the region(s) of the spectrum that
are summarized. If a numeric range is supplied a waveband object is
constructed on the fly from it.}

\item{quantity}{character string One of "average" or "mean", "contribution",
"contribution.pc", "relative" or "relative.pc"}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}

\item{naming}{character one of "long", "default", "short" or "none". Used to
select the type of names to assign to returned value.}

\item{...}{other arguments (possibly used by derived methods).}
}
\description{
This function returns the summary absorptance for a given waveband of a
\code{object_spct} object
}
\keyword{internal}
