% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{setHowMeasured}
\alias{setHowMeasured}
\alias{how_measured<-}
\alias{setHowMeasured.default}
\alias{setHowMeasured.generic_spct}
\alias{setHowMeasured.summary_generic_spct}
\alias{setHowMeasured.data.frame}
\alias{setHowMeasured.generic_mspct}
\title{Set the "how.measured" attribute}
\usage{
setHowMeasured(x, ...)

how_measured(x) <- value

\method{setHowMeasured}{default}(x, how.measured, ...)

\method{setHowMeasured}{generic_spct}(x, how.measured, ...)

\method{setHowMeasured}{summary_generic_spct}(x, how.measured, ...)

\method{setHowMeasured}{data.frame}(x, how.measured, ...)

\method{setHowMeasured}{generic_mspct}(x, how.measured, ...)
}
\arguments{
\item{x}{a R object.}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{how.measured, value}{a list or a character string.}
}
\value{
x modified by reference.
}
\description{
Method to set the \code{"how.measured"} attribute of an R object.
}
\section{Methods (by class)}{
\itemize{
\item \code{setHowMeasured(default)}: default

\item \code{setHowMeasured(generic_spct)}: generic_spct

\item \code{setHowMeasured(summary_generic_spct)}: summary_generic_spct

\item \code{setHowMeasured(data.frame)}: data.frame

\item \code{setHowMeasured(generic_mspct)}: generic_mspct

}}
\note{
This function alters \code{x} itself by reference and in addition
  returns \code{x} invisibly. If \code{x} is not an object of a supported
  class, \code{x} is silently returned unchanged.
}
\examples{
my.spct <- sun.spct
how_measured(my.spct)
how_measured(my.spct) <- "Simulated with a radiation transfer model"
how_measured(my.spct)
how_measured(my.spct) <- NULL
how_measured(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
