% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uv.r
\name{UV}
\alias{UV}
\title{Constructor of ultraviolet waveband}
\usage{
UV(std = "ISO")
}
\arguments{
\item{std}{"ISO" or "CIE"}
}
\value{
A waveband object defining a wavelength range.
}
\description{
Wavelength-range definition for \emph{ultraviolet (UV)} radiation according
to ISO and CIE standards.
}
\details{
UV: 100--400 nm. The ranges agree between CIE and ISO standards,
   thus, the argument passed to parameter \code{std} only affects the labels
   in the returned \code{waveband} object.
}
\examples{
UV()
UV("ISO")

}
\references{
Aphalo, P. J., Albert, A., Björn, L. O., McLeod, A. R., Robson,
T. M., Rosenqvist, E. (Eds.). (2012). Beyond the Visible: A handbook of best
practice in plant UV photobiology (1st ed., p. xxx + 174). Helsinki:
University of Helsinki, Department of Biosciences, Division of Plant Biology.
ISBN 978-952-10-8363-1 (PDF), 978-952-10-8362-4 (paperback). Open access PDF
download available at \doi{10.31885/9789521083631}.
}
\seealso{
\code{\link{new_waveband}}  \code{\link{waveband}}

Other unweighted wavebands: 
\code{\link{Blue}()},
\code{\link{Far_red}()},
\code{\link{Green}()},
\code{\link{IR}()},
\code{\link{Orange}()},
\code{\link{Purple}()},
\code{\link{Red}()},
\code{\link{UVA}()},
\code{\link{UVB}()},
\code{\link{UVC}()},
\code{\link{VIS}()},
\code{\link{Yellow}()}
}
\concept{unweighted wavebands}
