% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canape.rast.R
\name{.end.type}
\alias{.end.type}
\title{Classify Phylogenetic Endemism using rasters}
\usage{
.end.type(x)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster object with the following layers in this
specific order:
\itemize{
\item pe.obs.p.upper : Upper p-value comparing the observed phylogenetic
endemism and the randomized phylogenetic endemism values
\item pe.alt.obs.p.upper : Upper p-value comparing the alternate phylogenetic
endemism and the randomized alternate phylogenetic endemism
\item rpe.obs.p.upper : Upper p-value comparing the relative phylogenetic
endemism and the randomized relative phylogenetic endemism
\item rpe.obs.p.lower : Lower p-value comparing the relative phylogenetic
endemism and the randomized relative phylogenetic endemism
}}
}
\value{
SpatRaster
}
\description{
Use the results of rast.pe.ses() to identify centers of paleo-,
neo-, super-, and mixed- endemism following the CANAPE scheme of
Mishler et al., 2014.
}
\references{
Mishler, B., Knerr, N., González-Orozco, C. et al. (2014)
Phylogenetic measures of biodiversity and neo- and paleo-endemism in
Australian Acacia. Nat Commun, 5: 4473. doi:10.1038/ncomms5473
}
\keyword{internal}
