% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StackDataGPCM.R
\name{StackDataGPCM}
\alias{StackDataGPCM}
\title{Prepares data for up-dating association parameters of LMA (GPCM) model}
\usage{
StackDataGPCM(
  Master,
  item.log,
  starting.sv,
  npersons,
  nitems,
  ncat,
  nless,
  Maxnphi,
  pq.mat,
  LambdaNames,
  PhiNames
)
}
\arguments{
\item{Master}{Current master data frame}

\item{item.log}{Current history of iterations from which currenat 
a parameters are drawn}

\item{starting.sv}{Fixed category scores}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ncat}{Number of categories}

\item{nless}{Number of unique lambdas}

\item{Maxnphi}{Number of estimated phi parameters}

\item{pq.mat}{Array needed for rest-total scores}

\item{LambdaNames}{Names of lambdas in Master/Stacked data set}

\item{PhiNames}{Names of phi parameters}
}
\value{
stack.data	Formats data for input to mnlogit to up-date phi parameters
}
\description{
Prepares data frame for input to 'mnlogit' for the stacked regression 
to obtain association parameters of the multidimensional LMA models
corresponding to the GPCM.  This function is called from 'fit.gpcm'. 
It generally would not run outside of 'fit.nominal' or 'ple.lma'.
}
