% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_efourier.R
\name{efourier_coefs}
\alias{efourier_coefs}
\title{Get Fourier coefficients}
\usage{
efourier_coefs(x)
}
\arguments{
\item{x}{An object computed with \code{\link[=efourier]{efourier()}} or \code{\link[=efourier_norm]{efourier_norm()}}.}
}
\value{
A \code{data.frame} object
}
\description{
Extracts the Fourier coefficients from objects computed with \code{\link[=efourier]{efourier()}} and
\code{\link[=efourier_norm]{efourier_norm()}} returning a 'ready-to-analyze' data frame.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)

# a list of objects
efourier(contours) |> efourier_coefs()

# one object, normalized coefficients
efourier(contours[[4]]) |>
  efourier_norm() |>
  efourier_coefs()
}
}
