% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{image_augment}
\alias{image_augment}
\title{Augment Images}
\usage{
image_augment(
  img,
  pattern = NULL,
  times = 12,
  type = "export",
  dir_original = NULL,
  dir_processed = NULL,
  parallel = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{pattern}{A regular expression pattern to select multiple images from a
directory.}

\item{times}{The number of times to rotate the image.}

\item{type}{The type of output: "export" to save images or "return" to return
a list of augmented images.}

\item{dir_original}{The directory where original images are located.}

\item{dir_processed}{The directory where processed images will be saved.}

\item{parallel}{Whether to perform image augmentation in parallel.}

\item{verbose}{Whether to display progress messages.}
}
\value{
If type is "export," augmented images are saved. If type is "return,"
a list of augmented images is returned.
}
\description{
This function takes an image and augments it by rotating it multiple times.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("sev_leaf.jpg")
imgs <- image_augment(img, type = "return", times = 4)
image_combine(imgs)
}

}
