% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{sentinel_to_tif}
\alias{sentinel_to_tif}
\title{Convert Sentinel data to GeoTIFF format}
\usage{
sentinel_to_tif(layers = NULL, path = ".", destination, spat_res = 10)
}
\arguments{
\item{layers}{(character) Vector of file paths to Sentinel data files. If
NULL, the function searches for files in the specified path with names
containing "B".}

\item{path}{(character) Directory path where Sentinel data files are located.
Default is the current directory.}

\item{destination}{(character) File path for the output GeoTIFF file.}

\item{spat_res}{(numeric) Spatial resolution of the output GeoTIFF file.
Default is 10 meters.}
}
\description{
This function converts Sentinel satellite data files to GeoTIFF format.
}
\details{
The function converts Sentinel satellite data files to GeoTIFF
format using GDAL utilities. It builds a virtual raster file (VRT) from the
input files and then translates it to GeoTIFF format. Compression is
applied to the output GeoTIFF file using DEFLATE method.
}
