% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_index2}
\alias{mosaic_index2}
\title{Mosaic Index with GDAL}
\usage{
mosaic_index2(
  mosaic,
  index = "B",
  r = 3,
  g = 2,
  b = 1,
  re = 4,
  nir = 5,
  plot = TRUE,
  python = Sys.which("python.exe"),
  gdal = Sys.which("gdal_calc.py")
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{index}{A character value (or a vector of characters) specifying the
target mode for conversion to a binary image. Use \code{\link[=pliman_indexes_rgb]{pliman_indexes_rgb()}}
and \code{\link[=pliman_indexes_me]{pliman_indexes_me()}} to see the available RGB and multispectral
indexes, respectively. Users can also calculate their own index using  \verb{R, G, B, RE, NIR, SWIR, and TIR} bands (eg., \code{index = "R+B/G"}) or using the
names of the mosaic's layers (ex., "(band_1 + band_2) / 2").}

\item{r, g, b, re, nir}{The red, green, blue, red-edge, and  near-infrared bands
of the image, respectively. By default, the function assumes a BGR as input
(b = 1, g = 2, r = 3). If a multispectral image is provided up to seven
bands can be used to compute built-in indexes. There are no limitation of
band numbers if the index is computed using the band name.}

\item{plot}{Plot the computed index? Defaults to \code{TRUE}.}

\item{python}{The PATH for python.exe}

\item{gdal}{The PATH for gdal_calc.py}
}
\value{
An index layer extracted/computed from the mosaic raster.
}
\description{
Compute or extract an index layer from a multi-band mosaic raster using
gdal_calc.py (https://gdal.org/programs/gdal_calc.html). This requires a
Python and GDAL installation.
}
\examples{
if(interactive() & (Sys.which('python.exe') != '' ) & (Sys.which('gdal_calc.py') != '' )){
library(pliman)
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))
names(mosaic) <- "R"
elev2 <- mosaic_index2(mosaic, "R * 5", plot = FALSE)
oldpar <- par(no.readonly=TRUE)
mosaic_plot(mosaic)
mosaic_plot(elev2)
par(mfrow=c(1,2))
}
}
