% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.coxDKplsDR.R
\name{cv.coxDKplsDR}
\alias{cv.coxDKplsDR}
\title{Cross-validating a DKplsDR-Model}
\usage{
cv.coxDKplsDR(
  data,
  method = c("efron", "breslow"),
  nfold = 5,
  nt = 10,
  plot.it = TRUE,
  se = TRUE,
  givefold,
  scaleX = TRUE,
  folddetails = FALSE,
  allCVcrit = FALSE,
  details = FALSE,
  namedataset = "data",
  save = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A list of three items: \itemize{ \item\code{x} the explanatory
variables passed to \code{\link{coxDKplsDR}}'s \code{Xplan} argument,
\item\code{time} passed to \code{\link{coxDKplsDR}}'s \code{time} argument,
\item\code{status} \code{\link{coxDKplsDR}}'s \code{status} argument.  }}

\item{method}{A character string specifying the method for tie handling. If
there are no tied death times all the methods are equivalent. The Efron
approximation is used as the default here, it is more accurate when dealing
with tied death times, and is as efficient computationally.}

\item{nfold}{The number of folds to use to perform the cross-validation
process.}

\item{nt}{The number of components to include in the model. It this is not
supplied, 10 components are fitted.}

\item{plot.it}{Shall the results be displayed on a plot ?}

\item{se}{Should standard errors be plotted ?}

\item{givefold}{Explicit list of omited values in each fold can be provided
using this argument.}

\item{scaleX}{Shall the predictors be standardized ?}

\item{folddetails}{Should values and completion status for each folds be
returned ?}

\item{allCVcrit}{Should the other 13 CV criteria be evaled and returned ?}

\item{details}{Should all results of the functions that perform error
computations be returned ?}

\item{namedataset}{Name to use to craft temporary results names}

\item{save}{Should temporary results be saved ?}

\item{verbose}{Should some CV details be displayed ?}

\item{\dots}{Other arguments to pass to \code{\link{coxDKplsDR}}.}
}
\value{
\item{nt}{The number of components requested}
\item{cv.error1}{Vector with the mean values, across folds, of, per fold
unit, Cross-validated log-partial-likelihood for models with 0 to nt
components.} \item{cv.error2}{Vector with the mean values, across folds, of,
per fold unit, van Houwelingen Cross-validated log-partial-likelihood for
models with 0 to nt components.} \item{cv.error3}{Vector with the mean
values, across folds, of iAUC_CD for models with 0 to nt components.}
\item{cv.error4}{Vector with the mean values, across folds, of iAUC_hc for
models with 0 to nt components.} \item{cv.error5}{Vector with the mean
values, across folds, of iAUC_sh for models with 0 to nt components.}
\item{cv.error6}{Vector with the mean values, across folds, of iAUC_Uno for
models with 0 to nt components.} \item{cv.error7}{Vector with the mean
values, across folds, of iAUC_hz.train for models with 0 to nt components.}
\item{cv.error8}{Vector with the mean values, across folds, of iAUC_hz.test
for models with 0 to nt components.} \item{cv.error9}{Vector with the mean
values, across folds, of iAUC_survivalROC.train for models with 0 to nt
components.} \item{cv.error10}{Vector with the mean values, across folds, of
iAUC_survivalROC.test for models with 0 to nt components.}
\item{cv.error11}{Vector with the mean values, across folds, of iBrierScore
unw for models with 0 to nt components.} \item{cv.error12}{Vector with the
mean values, across folds, of iSchmidScore (robust BS) unw for models with 0
to nt components.} \item{cv.error13}{Vector with the mean values, across
folds, of iBrierScore w for models with 0 to nt components.}
\item{cv.error14}{Vector with the mean values, across folds, of iSchmidScore
(robust BS) w for models with 0 to nt components.} \item{cv.se1}{Vector with
the standard error values, across folds, of, per fold unit, Cross-validated
log-partial-likelihood for models with 0 to nt components.}
\item{cv.se2}{Vector with the standard error values, across folds, of, per
fold unit, van Houwelingen Cross-validated log-partial-likelihood for models
with 0 to nt components.} \item{cv.se3}{Vector with the standard error
values, across folds, of iAUC_CD for models with 0 to nt components.}
\item{cv.se4}{Vector with the standard error values, across folds, of
iAUC_hc for models with 0 to nt components.} \item{cv.se5}{Vector with the
standard error values, across folds, of iAUC_sh for models with 0 to nt
components.} \item{cv.se6}{Vector with the standard error values, across
folds, of iAUC_Uno for models with 0 to nt components.} \item{cv.se7}{Vector
with the standard error values, across folds, of iAUC_hz.train for models
with 0 to nt components.} \item{cv.se8}{Vector with the standard error
values, across folds, of iAUC_hz.test for models with 0 to nt components.}
\item{cv.se9}{Vector with the standard error values, across folds, of
iAUC_survivalROC.train for models with 0 to nt components.}
\item{cv.se10}{Vector with the standard error values, across folds, of
iAUC_survivalROC.test for models with 0 to nt components.}
\item{cv.se11}{Vector with the standard error values, across folds, of
iBrierScore unw for models with 0 to nt components.} \item{cv.se12}{Vector
with the standard error values, across folds, of iSchmidScore (robust BS)
unw for models with 0 to nt components.} \item{cv.se13}{Vector with the
standard error values, across folds, of iBrierScore w for models with 0 to
nt components.} \item{cv.se14}{Vector with the standard error values, across
folds, of iSchmidScore (robust BS) w for models with 0 to nt components.}
\item{folds}{Explicit list of the values that were omited values in each
fold.} \item{lambda.min1}{Vector with the standard error values, across
folds, of, per fold unit, Cross-validated log-partial-likelihood for models
with 0 to nt components.} \item{lambda.min2}{Vector with the standard error
values, across folds, of, per fold unit, van Houwelingen Cross-validated
log-partial-likelihood for models with 0 to nt components.}
\item{lambda.min1}{Optimal Nbr of components, min Cross-validated
log-partial-likelihood criterion.} \item{lambda.se1}{Optimal Nbr of
components, min+1se Cross-validated log-partial-likelihood criterion.}
\item{lambda.min2}{Optimal Nbr of components, min van Houwelingen
Cross-validated log-partial-likelihood.} \item{lambda.se2}{Optimal Nbr of
components, min+1se van Houwelingen Cross-validated log-partial-likelihood.}
\item{lambda.min3}{Optimal Nbr of components, max iAUC_CD criterion.}
\item{lambda.se3}{Optimal Nbr of components, max+1se iAUC_CD criterion.}
\item{lambda.min4}{Optimal Nbr of components, max iAUC_hc criterion.}
\item{lambda.se4}{Optimal Nbr of components, max+1se iAUC_hc criterion.}
\item{lambda.min5}{Optimal Nbr of components, max iAUC_sh criterion.}
\item{lambda.se5}{Optimal Nbr of components, max+1se iAUC_sh criterion.}
\item{lambda.min6}{Optimal Nbr of components, max iAUC_Uno criterion.}
\item{lambda.se6}{Optimal Nbr of components, max+1se iAUC_Uno criterion.}
\item{lambda.min7}{Optimal Nbr of components, max iAUC_hz.train criterion.}
\item{lambda.se7}{Optimal Nbr of components, max+1se iAUC_hz.train
criterion.} \item{lambda.min8}{Optimal Nbr of components, max iAUC_hz.test
criterion.} \item{lambda.se8}{Optimal Nbr of components, max+1se
iAUC_hz.test criterion.} \item{lambda.min9}{Optimal Nbr of components, max
iAUC_survivalROC.train criterion.} \item{lambda.se9}{Optimal Nbr of
components, max+1se iAUC_survivalROC.train criterion.}
\item{lambda.min10}{Optimal Nbr of components, max iAUC_survivalROC.test
criterion.} \item{lambda.se10}{Optimal Nbr of components, max+1se
iAUC_survivalROC.test criterion.} \item{lambda.min11}{Optimal Nbr of
components, min iBrierScore unw criterion.} \item{lambda.se11}{Optimal Nbr
of components, min+1se iBrierScore unw criterion.}
\item{lambda.min12}{Optimal Nbr of components, min iSchmidScore unw
criterion.} \item{lambda.se12}{Optimal Nbr of components, min+1se
iSchmidScore unw criterion.} \item{lambda.min13}{Optimal Nbr of components,
min iBrierScore w criterion.} \item{lambda.se13}{Optimal Nbr of components,
min+1se iBrierScore w criterion.} \item{lambda.min14}{Optimal Nbr of
components, min iSchmidScore w criterion.} \item{lambda.se14}{Optimal Nbr of
components, min+1se iSchmidScore w criterion.} \item{errormat1-14}{If
\code{details=TRUE}, matrices with the error values for every folds across
each of the components and each of the criteria} \item{completed.cv1-14}{If
\code{details=TRUE}, matrices with logical values for every folds across
each of the components and each of the criteria: \code{TRUE} if the
computation was completed and \code{FALSE} it is failed.}
\item{All_indics}{All results of the functions that perform error
computation, for each fold, each component and error criterion.}
}
\description{
This function cross-validates \link{coxDKplsDR} models.\cr
}
\details{
It only computes the recommended iAUCSurvROC criterion. Set
\code{allCVcrit=TRUE} to retrieve the 13 other ones.
}
\examples{

data(micro.censure)
data(Xmicro.censure_compl_imp)
set.seed(123456)
X_train_micro <- apply((as.matrix(Xmicro.censure_compl_imp)),FUN="as.numeric",MARGIN=2)[1:80,]
X_train_micro_df <- data.frame(X_train_micro)
Y_train_micro <- micro.censure$survyear[1:80]
C_train_micro <- micro.censure$DC[1:80]

#Should be run with a higher value of nt (at least 10)
(cv.coxDKplsDR.res=cv.coxDKplsDR(list(x=X_train_micro,time=Y_train_micro,
status=C_train_micro),nt=3))

}
\references{
plsRcox, Cox-Models in a high dimensional setting in R, Frederic
Bertrand, Philippe Bastien, Nicolas Meyer and Myriam Maumy-Bertrand (2014).
Proceedings of User2014!, Los Angeles, page 152.\cr

Deviance residuals-based sparse PLS and sparse kernel PLS regression for
censored data, Philippe Bastien, Frederic Bertrand, Nicolas Meyer and Myriam
Maumy-Bertrand (2015), Bioinformatics, 31(3):397-404,
doi:10.1093/bioinformatics/btu660.

Cross validating extensions of kernel, sparse or regular partial least
squares regression models to censored data, Bertrand, F., Bastien, Ph. and
Maumy-Bertrand, M. (2018), \url{https://arxiv.org/abs/1810.01005}.
}
\seealso{
See Also \code{\link{coxDKplsDR}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{http://www-irma.u-strasbg.fr/~fbertran/}
}
\keyword{models}
\keyword{regression}
