% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finite-diff.R
\name{solveVandermonde}
\alias{solveVandermonde}
\title{Numerically stable non-confluent Vandermonde system solver}
\usage{
solveVandermonde(s, b)
}
\arguments{
\item{s}{Numeric vector of stencil points defining the Vandermonde matrix on
the left-hand side, where each element \eqn{S_{i, j}}{S_ij} is calculated as
\code{s[j]^(i-1)}.}

\item{b}{Numeric vector of the right-hand side of the equation.
This vector must be the same length as \code{s}.}
}
\value{
A numeric vector of coefficients solving the Vandermonde system,
matching the length of \code{s}.
}
\description{
Numerically stable non-confluent Vandermonde system solver
}
\details{
This function utilises the \insertCite{bjorck1970solution}{pnd} algorithm for
an accurate solution to non-confluent Vandermonde systems,
which are known for their numerical instability. Unlike Gaussian elimination,
which suffers from ill conditioning, this algorithm achieves numerical stability
through exploiting the ordering of the stencil.
An unsorted stencils will trigger a warning.
Additionally, the stencil must contain unique points, as repeated values make
the Vandermonde matrix confluent and therefore non-invertible.

This implementation is a verbatim translation of Algorithm 4.6.2 from
\insertCite{golub2013matrix}{pnd}, which is robust against the issues
typically associated with Vandermonde systems.

See \insertCite{higham1987error}{pnd} for an in-depth error analysis of this algorithm.
}
\examples{

# Approximate the 4th derivatives on a non-negative stencil
solveVandermonde(s = 0:5, b = c(0, 0, 0, 0, 24, 0))

# Small numerical inaccuracies: note the 6.66e-15 in the 4th position --
# it should be rounded towards zero:
solveVandermonde(s = -3:3, b = c(0, 1, rep(0, 5))) * 60
}
\references{
\insertAllCited{}
}
