% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComparabilitySetOf.R
\name{ComparabilitySetOf}
\alias{ComparabilitySetOf}
\title{Extracting the comparability set of a poset element.}
\usage{
ComparabilitySetOf(poset, element)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{element}{A character string (the name of the input poset element).}
}
\value{
A vector of character strings (the names of the poset elements comparable to the input element).
}
\description{
Extracts the elements comparable with the input element, in the poset.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

cmp <- ComparabilitySetOf(pos, "a")

}
