% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcs_ptp.R
\name{calculate_dcs_1993_risk_factor_index}
\alias{calculate_dcs_1993_risk_factor_index}
\title{Calculate The Risk Factor Index For Duke Clinical Score 1993}
\usage{
calculate_dcs_1993_risk_factor_index(
  have_hypertension,
  have_dyslipidemia,
  have_diabetes,
  max_na = 0
)
}
\arguments{
\item{have_hypertension}{Input characters (no, yes) to indicate if the patient
has hypertension.
\itemize{
  \item no stands for not having hypertension.
  \item yes stands for having hypertension.
}}

\item{have_dyslipidemia}{Input characters (no, yes) to indicate if the patient
has dyslipidemia.
\itemize{
  \item no stands for not having dyslipidemia.
  \item yes stands for having dyslipidemia.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{max_na}{Input integer 0 to 3 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}
}
\value{
An integer indicating the patient's risk factor index.
It can also be \code{NA} if the number of missing risk factors exceeds the \code{max_na}
input value.
}
\description{
A function used to calculate the patient's
risk factor index. This is used to calculate the likelihood
of severe coronary artery disease in the
Duke Clinical Score 1993 paper.
}
\examples{
calculate_dcs_1993_risk_factor_index(
  have_hypertension = "yes",
  have_dyslipidemia = "yes",
  have_diabetes = "no"
)

calculate_dcs_1993_risk_factor_index(
  have_hypertension = NA,
  have_dyslipidemia = "yes",
  have_diabetes = "no",
  max_na = 0
)

calculate_dcs_1993_risk_factor_index(
  have_hypertension = NA,
  have_dyslipidemia = "yes",
  have_diabetes = "no",
  max_na = 1
)
}
