% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StudySpecificationUtilities.R
\name{unit_of_assignment}
\alias{unit_of_assignment}
\alias{unitid}
\alias{cluster}
\alias{uoa}
\alias{block}
\alias{forcing}
\title{Special terms in \code{StudySpecification} creation formula}
\usage{
unit_of_assignment(...)

unitid(...)

cluster(...)

uoa(...)

block(...)

forcing(...)
}
\arguments{
\item{...}{any number of variables of the same length.}
}
\value{
the variables with appropriate labels. No use outside of their
inclusion in the \code{formula} argument to \code{obs_spec},
\code{rct_spec}, or \code{rd_spec}
}
\description{
These are special functions used only in the definition of
\code{StudySpecification} objects. They identify the units of assignment,
blocks and forcing variables. They should never be used outside of the
\code{formula} argument to \code{obs_spec}, \code{rct_spec}, or
\code{rd_spec}.
}
\details{
These functions have no use outside of the formula in creating a
\code{StudySpecification}.

\code{unit_of_assignment}, \code{uoa}, \code{cluster} and \code{unitid}
are synonyms; you must include one and only one in each
\code{StudySpecification}. The choice of which to use will have no impact
on any analysis, only on some output and the name of the stored element in
the \code{StudySpecification}. Accessors/ replacers
(\code{units_of_assignment}, \code{unitids}, \code{clusters}) respect the
choice made at the point of creation of the \code{StudySpecification}, and
only the appropriate function will work.

See \code{rct_spec}, \code{obs_spec}, or \code{rd_spec} for examples of
their usage.
}
