% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_spectral_density.R
\name{MakeOneSidedAmplitudeSpectrum}
\alias{MakeOneSidedAmplitudeSpectrum}
\title{Create a one sided amplitude spectrum using time series data}
\usage{
MakeOneSidedAmplitudeSpectrum(sampling_frequency, data_vector)
}
\arguments{
\item{sampling_frequency}{Numeric value specifying sampling frequency in hertz. If data is sampled once every second, then sampling frequency is 1 Hz. If data is sampled once every 2 seconds, then sampling frequency is 0.5 Hz.}

\item{data_vector}{Vector of numeric values. Time series vector of data.}
}
\value{
A List with two objects:
\enumerate{
\item Vector of frequencies in Hz. The maximum frequency should be half the sampling frequency. Called Nyquist Frequency.
\item Vector amplitudes corresponding with each frequency. Units should be in the original units of the data vector.
}

The vector of frequencies can be used as the x-axis values of a single sided spectrum amplitude plot.
The vector of amplitudes can be used as the y-axis values of a single sided spectrum.
}
\description{
An explanation for some of the math can be found here: https://www.mathworks.com/help/matlab/ref/fft.html
}
\examples{

#Create a vector of time that represent times where data are sampled.
Fs = 100; #sampling frequency in Hz
T = 1/Fs; #sampling period
L = 1000; #length of time vector
t = (0:(L-1))*T; #time vector

#Form a signal (time series) that contains two frequencies:
#1. 10 Hz with amplitude of 1
#2. 25 Hz with amplitude of 2
S <- 1*sin(2*pi*10*t) + 2*sin(2*pi*25*t);

results <- MakeOneSidedAmplitudeSpectrum(Fs, S)

frequencies <- results[[1]]

amplitudes <- results[[2]]

#dev.new()
plot(frequencies, amplitudes, type = "l")


}
