% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_object_S3_methods.R
\name{AIC.pvEBayes}
\alias{AIC.pvEBayes}
\title{Obtain Akaike Information Criterion (AIC) for a pvEBayes object}
\usage{
\method{AIC}{pvEBayes}(object, ..., k = 2)
}
\arguments{
\item{object}{a \code{pvEBayes} object, which is the output of the function
\link{pvEBayes} or \link{pvEBayes_tune}.}

\item{...}{other input parameters. Currently unused.}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2
is the classical AIC.}
}
\value{
numeric, AIC score for the resulting model.
}
\description{
This function defines the S3 \code{AIC} method for objects of class
\code{pvEBayes}. It extracts the Akaike Information Criterion (AIC)
from a fitted model.
}
\examples{

fit <- pvEBayes(
  contin_table = statin2025_44, model = "general-gamma",
  alpha = 0.3, n_posterior_draws = NULL
)

AIC_score <- AIC(fit)

}
