% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{boot_ci}
\alias{boot_ci}
\title{Bootstrapped Confidence Intervals from a Matrix of Coefficients}
\usage{
boot_ci(coef, est = colMeans(coef), boot.ci.type = "perc2", level = 0.95)
}
\arguments{
\item{coef}{numeric matrix (or data.frame of numeric columns) of
coefficients. The rows correspond to each bootstrapped resample and the
columns to different coefficients. This is the equivalent of the "t"
element in a \code{boot} object.}

\item{est}{numeric vector of observed coefficients from the full sample. This
is the equivalent of the "t0" element in a \code{boot} object. The default
takes the mean of each coefficient across bootstrapped resamples; however,
this usually results in small amount of bias in the coefficients.}

\item{boot.ci.type}{character vector of length 1 specifying the type of
bootstrapped confidence interval to compute. The options are 1) "perc2" for
the naive percentile method using \code{\link{quantile}}, and 2) "norm2"
for the normal method that uses the bootstrapped standard error to
construct symmetrical confidence intervals with the classic formula around
the estimate, The options have a "2" after them because, although they are
conceptually similar to the "perc" and "norm" methods in the
\code{\link[boot]{boot.ci}} function, they are slightly different
mathematically.}

\item{level}{double vector of length 1 specifying the confidence level. Must
be between 0 and 1.}
}
\value{
data.frame will be returned with nrow equal to the number of
coefficients bootstrapped and columns specified below. The rownames are the
colnames in the \code{coef} argument or the names in the \code{est} argument
(default data.frame rownames if neither have any names). The columns are the
following:

\describe{
   \item{est}{original parameter estimates}
   \item{se}{bootstrapped standard errors (does not differ by \code{boot.ci.type})}
   \item{lwr}{lower bound of the bootstrapped confidence intervals}
   \item{upr}{upper bound of the bootstrapped confidence intervals}
}
}
\description{
\code{boot_ci} computes bootstrapped confidence intervals from a matrix of
coefficients (or any statistical information of interest). The function is an
alternative to \code{confint2.boot} for when the user does not have an object
of class \code{boot}, but rather creates their own matrix of coefficients. It
has limited types of bootstrapped confidence intervals at the moment, but
future versions are expected to have more options.
}
\examples{

tmp <- replicate(n = 100, expr = {
   i <- sample.int(nrow(attitude), replace = TRUE)
   colMeans(attitude[i, ])
}, simplify = FALSE)
mat <- str2str::lv2m(tmp, along = 1)
boot_ci(mat, est = colMeans(attitude))

}
\seealso{
\code{\link[boot]{boot.ci}} for the confidence interval function in the \code{boot} package,
   \code{\link[car]{confint.boot}} for an alternative function with \code{boot} objects
}
