% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/street_network_to_sf.R
\name{street_network_to_sf}
\alias{street_network_to_sf}
\title{Extract OpenStreetMap network in sf format from a network.dat file}
\usage{
street_network_to_sf(r5r_core)
}
\arguments{
\item{r5r_core}{An object to connect with the R5 routing engine, created with
\code{\link[=setup_r5]{setup_r5()}}.}
}
\value{
A list with two components of a street network in sf format: vertices
(POINT) and edges (LINESTRING).
}
\description{
Extract OpenStreetMap network in sf format from a network.dat file
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(r5r)

# build transport network
path <- system.file("extdata/poa", package = "r5r")
r5r_core <- setup_r5(path)

# extract street network from r5r_core
street_net <- street_network_to_sf(r5r_core)

stop_r5(r5r_core)
\dontshow{\}) # examplesIf}
}
\seealso{
Other network functions: 
\code{\link{find_snap}()},
\code{\link{transit_network_to_sf}()}
}
\concept{network functions}
